@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.DotNetComponentArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.DotNetComponentType
import com.pulumi.azurenative.app.kotlin.inputs.DotNetComponentConfigurationPropertyArgs
import com.pulumi.azurenative.app.kotlin.inputs.DotNetComponentConfigurationPropertyArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.DotNetComponentServiceBindArgs
import com.pulumi.azurenative.app.kotlin.inputs.DotNetComponentServiceBindArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * .NET Component.
 * Azure REST API version: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update .NET Component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dotNetComponent = new AzureNative.App.DotNetComponent("dotNetComponent", new()
 *     {
 *         ComponentType = AzureNative.App.DotNetComponentType.AspireDashboard,
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.DotNetComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "dashboard-theme",
 *                 Value = "dark",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "mydotnetcomponent",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDotNetComponent(ctx, "dotNetComponent", &app.DotNetComponentArgs{
 * 			ComponentType: pulumi.String(app.DotNetComponentTypeAspireDashboard),
 * 			Configurations: app.DotNetComponentConfigurationPropertyArray{
 * 				&app.DotNetComponentConfigurationPropertyArgs{
 * 					PropertyName: pulumi.String("dashboard-theme"),
 * 					Value:        pulumi.String("dark"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mydotnetcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DotNetComponent;
 * import com.pulumi.azurenative.app.DotNetComponentArgs;
 * import com.pulumi.azurenative.app.inputs.DotNetComponentConfigurationPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dotNetComponent = new DotNetComponent("dotNetComponent", DotNetComponentArgs.builder()
 *             .componentType("AspireDashboard")
 *             .configurations(DotNetComponentConfigurationPropertyArgs.builder()
 *                 .propertyName("dashboard-theme")
 *                 .value("dark")
 *                 .build())
 *             .environmentName("myenvironment")
 *             .name("mydotnetcomponent")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update .NET Component with ServiceBinds
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dotNetComponent = new AzureNative.App.DotNetComponent("dotNetComponent", new()
 *     {
 *         ComponentType = AzureNative.App.DotNetComponentType.AspireDashboard,
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.DotNetComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "dashboard-theme",
 *                 Value = "dark",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "mydotnetcomponent",
 *         ResourceGroupName = "examplerg",
 *         ServiceBinds = new[]
 *         {
 *             new AzureNative.App.Inputs.DotNetComponentServiceBindArgs
 *             {
 *                 Name = "yellowcat",
 *                 ServiceId = "/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/dotNetComponents/yellowcat",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDotNetComponent(ctx, "dotNetComponent", &app.DotNetComponentArgs{
 * 			ComponentType: pulumi.String(app.DotNetComponentTypeAspireDashboard),
 * 			Configurations: app.DotNetComponentConfigurationPropertyArray{
 * 				&app.DotNetComponentConfigurationPropertyArgs{
 * 					PropertyName: pulumi.String("dashboard-theme"),
 * 					Value:        pulumi.String("dark"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mydotnetcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			ServiceBinds: app.DotNetComponentServiceBindArray{
 * 				&app.DotNetComponentServiceBindArgs{
 * 					Name:      pulumi.String("yellowcat"),
 * 					ServiceId: pulumi.String("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/dotNetComponents/yellowcat"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DotNetComponent;
 * import com.pulumi.azurenative.app.DotNetComponentArgs;
 * import com.pulumi.azurenative.app.inputs.DotNetComponentConfigurationPropertyArgs;
 * import com.pulumi.azurenative.app.inputs.DotNetComponentServiceBindArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dotNetComponent = new DotNetComponent("dotNetComponent", DotNetComponentArgs.builder()
 *             .componentType("AspireDashboard")
 *             .configurations(DotNetComponentConfigurationPropertyArgs.builder()
 *                 .propertyName("dashboard-theme")
 *                 .value("dark")
 *                 .build())
 *             .environmentName("myenvironment")
 *             .name("mydotnetcomponent")
 *             .resourceGroupName("examplerg")
 *             .serviceBinds(DotNetComponentServiceBindArgs.builder()
 *                 .name("yellowcat")
 *                 .serviceId("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/dotNetComponents/yellowcat")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DotNetComponent mydotnetcomponent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/dotNetComponents/{name}
 * ```
 * @property componentType Type of the .NET Component.
 * @property configurations List of .NET Components configuration properties
 * @property environmentName Name of the Managed Environment.
 * @property name Name of the .NET Component.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceBinds List of .NET Components that are bound to the .NET component
 */
public data class DotNetComponentArgs(
    public val componentType: Output<Either<String, DotNetComponentType>>? = null,
    public val configurations: Output<List<DotNetComponentConfigurationPropertyArgs>>? = null,
    public val environmentName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceBinds: Output<List<DotNetComponentServiceBindArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.DotNetComponentArgs> {
    override fun toJava(): com.pulumi.azurenative.app.DotNetComponentArgs =
        com.pulumi.azurenative.app.DotNetComponentArgs.builder()
            .componentType(
                componentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceBinds(
                serviceBinds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DotNetComponentArgs].
 */
@PulumiTagMarker
public class DotNetComponentArgsBuilder internal constructor() {
    private var componentType: Output<Either<String, DotNetComponentType>>? = null

    private var configurations: Output<List<DotNetComponentConfigurationPropertyArgs>>? = null

    private var environmentName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceBinds: Output<List<DotNetComponentServiceBindArgs>>? = null

    /**
     * @param value Type of the .NET Component.
     */
    @JvmName("yxoaopwhxonvewww")
    public suspend fun componentType(`value`: Output<Either<String, DotNetComponentType>>) {
        this.componentType = value
    }

    /**
     * @param value List of .NET Components configuration properties
     */
    @JvmName("dasuxsdrolilroqd")
    public suspend fun configurations(`value`: Output<List<DotNetComponentConfigurationPropertyArgs>>) {
        this.configurations = value
    }

    @JvmName("xxkbbemkybbcodnd")
    public suspend fun configurations(vararg values: Output<DotNetComponentConfigurationPropertyArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values List of .NET Components configuration properties
     */
    @JvmName("qwvdywacvkxyagkd")
    public suspend fun configurations(values: List<Output<DotNetComponentConfigurationPropertyArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("vcfembjjuostttkh")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Name of the .NET Component.
     */
    @JvmName("rjijbyxwvyxlmquu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggwwwlqbqbjbirxr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of .NET Components that are bound to the .NET component
     */
    @JvmName("jhylhajavndomdag")
    public suspend fun serviceBinds(`value`: Output<List<DotNetComponentServiceBindArgs>>) {
        this.serviceBinds = value
    }

    @JvmName("iadxihnwqlsymxty")
    public suspend fun serviceBinds(vararg values: Output<DotNetComponentServiceBindArgs>) {
        this.serviceBinds = Output.all(values.asList())
    }

    /**
     * @param values List of .NET Components that are bound to the .NET component
     */
    @JvmName("mqsqjsmunnttvsrj")
    public suspend fun serviceBinds(values: List<Output<DotNetComponentServiceBindArgs>>) {
        this.serviceBinds = Output.all(values)
    }

    /**
     * @param value Type of the .NET Component.
     */
    @JvmName("nxvfethibexfysdh")
    public suspend fun componentType(`value`: Either<String, DotNetComponentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Type of the .NET Component.
     */
    @JvmName("jvregkuwsvmmgjyn")
    public fun componentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DotNetComponentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Type of the .NET Component.
     */
    @JvmName("gotrpotwsneuwnin")
    public fun componentType(`value`: DotNetComponentType) {
        val toBeMapped = Either.ofRight<String, DotNetComponentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value List of .NET Components configuration properties
     */
    @JvmName("ijysjfijiidvdeao")
    public suspend fun configurations(`value`: List<DotNetComponentConfigurationPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument List of .NET Components configuration properties
     */
    @JvmName("kaxmnrandamokktt")
    public suspend fun configurations(argument: List<suspend DotNetComponentConfigurationPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DotNetComponentConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument List of .NET Components configuration properties
     */
    @JvmName("ybevbflapavtbjch")
    public suspend fun configurations(vararg argument: suspend DotNetComponentConfigurationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DotNetComponentConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument List of .NET Components configuration properties
     */
    @JvmName("sslimckvclyslteg")
    public suspend fun configurations(argument: suspend DotNetComponentConfigurationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DotNetComponentConfigurationPropertyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values List of .NET Components configuration properties
     */
    @JvmName("cnkjahfjcrpwntlb")
    public suspend fun configurations(vararg values: DotNetComponentConfigurationPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("nrhkvwcgagskfdff")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the .NET Component.
     */
    @JvmName("wqgotlftqqjgmbqb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qjdeebgcspumanuj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of .NET Components that are bound to the .NET component
     */
    @JvmName("iqxqcqfwoiwlhedj")
    public suspend fun serviceBinds(`value`: List<DotNetComponentServiceBindArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBinds = mapped
    }

    /**
     * @param argument List of .NET Components that are bound to the .NET component
     */
    @JvmName("ueyyvgfjcrhyhfpf")
    public suspend fun serviceBinds(argument: List<suspend DotNetComponentServiceBindArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DotNetComponentServiceBindArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBinds = mapped
    }

    /**
     * @param argument List of .NET Components that are bound to the .NET component
     */
    @JvmName("knpnyjkabqliudkk")
    public suspend fun serviceBinds(vararg argument: suspend DotNetComponentServiceBindArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DotNetComponentServiceBindArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBinds = mapped
    }

    /**
     * @param argument List of .NET Components that are bound to the .NET component
     */
    @JvmName("jgxjknkpbbuakdkp")
    public suspend fun serviceBinds(argument: suspend DotNetComponentServiceBindArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DotNetComponentServiceBindArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceBinds = mapped
    }

    /**
     * @param values List of .NET Components that are bound to the .NET component
     */
    @JvmName("xavnedoxyihumsvj")
    public suspend fun serviceBinds(vararg values: DotNetComponentServiceBindArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceBinds = mapped
    }

    internal fun build(): DotNetComponentArgs = DotNetComponentArgs(
        componentType = componentType,
        configurations = configurations,
        environmentName = environmentName,
        name = name,
        resourceGroupName = resourceGroupName,
        serviceBinds = serviceBinds,
    )
}
