@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * ActiveRevisionsMode controls how active revisions are handled for the Container app:
 * <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
 */
public enum class ActiveRevisionsMode(
    public val javaValue: com.pulumi.azurenative.app.enums.ActiveRevisionsMode,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.ActiveRevisionsMode> {
    Multiple(com.pulumi.azurenative.app.enums.ActiveRevisionsMode.Multiple),
    Single(com.pulumi.azurenative.app.enums.ActiveRevisionsMode.Single),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.ActiveRevisionsMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.ActiveRevisionsMode): ActiveRevisionsMode = ActiveRevisionsMode.values().first { it.javaValue == javaType }
    }
}
