@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AzureActiveDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active directory provider.
 * @property enabled <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property isAutoProvisioned Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
 * This is an internal flag primarily intended to support the Azure Management Portal. Users should not
 * read or write to this property.
 * @property login The configuration settings of the Azure Active Directory login flow.
 * @property registration The configuration settings of the Azure Active Directory app registration.
 * @property validation The configuration settings of the Azure Active Directory token validation flow.
 */
public data class AzureActiveDirectoryArgs(
    public val enabled: Output<Boolean>? = null,
    public val isAutoProvisioned: Output<Boolean>? = null,
    public val login: Output<AzureActiveDirectoryLoginArgs>? = null,
    public val registration: Output<AzureActiveDirectoryRegistrationArgs>? = null,
    public val validation: Output<AzureActiveDirectoryValidationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AzureActiveDirectoryArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AzureActiveDirectoryArgs =
        com.pulumi.azurenative.app.inputs.AzureActiveDirectoryArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .isAutoProvisioned(isAutoProvisioned?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validation(validation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AzureActiveDirectoryArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var isAutoProvisioned: Output<Boolean>? = null

    private var login: Output<AzureActiveDirectoryLoginArgs>? = null

    private var registration: Output<AzureActiveDirectoryRegistrationArgs>? = null

    private var validation: Output<AzureActiveDirectoryValidationArgs>? = null

    /**
     * @param value <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("nkvydadkhvwnvoih")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
     * This is an internal flag primarily intended to support the Azure Management Portal. Users should not
     * read or write to this property.
     */
    @JvmName("abwnoexthwfchmbb")
    public suspend fun isAutoProvisioned(`value`: Output<Boolean>) {
        this.isAutoProvisioned = value
    }

    /**
     * @param value The configuration settings of the Azure Active Directory login flow.
     */
    @JvmName("xhkmgnpqgoqoxbkg")
    public suspend fun login(`value`: Output<AzureActiveDirectoryLoginArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the Azure Active Directory app registration.
     */
    @JvmName("bjaeuxieovuyglmb")
    public suspend fun registration(`value`: Output<AzureActiveDirectoryRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value The configuration settings of the Azure Active Directory token validation flow.
     */
    @JvmName("drdllhnjkibbmmcp")
    public suspend fun validation(`value`: Output<AzureActiveDirectoryValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("rooebvcfgflylyyj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
     * This is an internal flag primarily intended to support the Azure Management Portal. Users should not
     * read or write to this property.
     */
    @JvmName("pfmlwwhvxckjkrxj")
    public suspend fun isAutoProvisioned(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoProvisioned = mapped
    }

    /**
     * @param value The configuration settings of the Azure Active Directory login flow.
     */
    @JvmName("gotjjtbtvwpcdnco")
    public suspend fun login(`value`: AzureActiveDirectoryLoginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Active Directory login flow.
     */
    @JvmName("yvjautbvaklsxtye")
    public suspend fun login(argument: suspend AzureActiveDirectoryLoginArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryLoginArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the Azure Active Directory app registration.
     */
    @JvmName("qwtyfgsvirxprxsa")
    public suspend fun registration(`value`: AzureActiveDirectoryRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Active Directory app registration.
     */
    @JvmName("rqjcbnolwclxyvdk")
    public suspend fun registration(argument: suspend AzureActiveDirectoryRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryRegistrationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    /**
     * @param value The configuration settings of the Azure Active Directory token validation flow.
     */
    @JvmName("dowfpxjitcogeeyc")
    public suspend fun validation(`value`: AzureActiveDirectoryValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Active Directory token validation flow.
     */
    @JvmName("npxpwkqwwablvnnv")
    public suspend fun validation(argument: suspend AzureActiveDirectoryValidationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryValidationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): AzureActiveDirectoryArgs = AzureActiveDirectoryArgs(
        enabled = enabled,
        isAutoProvisioned = isAutoProvisioned,
        login = login,
        registration = registration,
        validation = validation,
    )
}
