@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ConnectedEnvironmentStoragePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage properties
 * @property azureFile Azure file properties
 */
public data class ConnectedEnvironmentStoragePropertiesArgs(
    public val azureFile: Output<AzureFilePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ConnectedEnvironmentStoragePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ConnectedEnvironmentStoragePropertiesArgs = com.pulumi.azurenative.app.inputs.ConnectedEnvironmentStoragePropertiesArgs.builder()
        .azureFile(azureFile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectedEnvironmentStoragePropertiesArgs].
 */
@PulumiTagMarker
public class ConnectedEnvironmentStoragePropertiesArgsBuilder internal constructor() {
    private var azureFile: Output<AzureFilePropertiesArgs>? = null

    /**
     * @param value Azure file properties
     */
    @JvmName("vytrcluvgwlhqyve")
    public suspend fun azureFile(`value`: Output<AzureFilePropertiesArgs>) {
        this.azureFile = value
    }

    /**
     * @param value Azure file properties
     */
    @JvmName("itomamylrpfunwbh")
    public suspend fun azureFile(`value`: AzureFilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFile = mapped
    }

    /**
     * @param argument Azure file properties
     */
    @JvmName("tkkgbovjwfbaklob")
    public suspend fun azureFile(argument: suspend AzureFilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFile = mapped
    }

    internal fun build(): ConnectedEnvironmentStoragePropertiesArgs =
        ConnectedEnvironmentStoragePropertiesArgs(
            azureFile = azureFile,
        )
}
