@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpGetArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.Scheme
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * HTTPGet specifies the http request to perform.
 * @property host Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
 * @property httpHeaders Custom headers to set in the request. HTTP allows repeated headers.
 * @property path Path to access on the HTTP server.
 * @property port Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 * @property scheme Scheme to use for connecting to the host. Defaults to HTTP.
 */
public data class ContainerAppProbeHttpGetArgs(
    public val host: Output<String>? = null,
    public val httpHeaders: Output<List<ContainerAppProbeHttpHeadersArgs>>? = null,
    public val path: Output<String>? = null,
    public val port: Output<Int>,
    public val scheme: Output<Either<String, Scheme>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpGetArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpGetArgs =
        com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpGetArgs.builder()
            .host(host?.applyValue({ args0 -> args0 }))
            .httpHeaders(
                httpHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .scheme(
                scheme?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerAppProbeHttpGetArgs].
 */
@PulumiTagMarker
public class ContainerAppProbeHttpGetArgsBuilder internal constructor() {
    private var host: Output<String>? = null

    private var httpHeaders: Output<List<ContainerAppProbeHttpHeadersArgs>>? = null

    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var scheme: Output<Either<String, Scheme>>? = null

    /**
     * @param value Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
     */
    @JvmName("avldvormyfytwyco")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("ncvkxlkvdeiwpsgf")
    public suspend fun httpHeaders(`value`: Output<List<ContainerAppProbeHttpHeadersArgs>>) {
        this.httpHeaders = value
    }

    @JvmName("egbhvyikwejylked")
    public suspend fun httpHeaders(vararg values: Output<ContainerAppProbeHttpHeadersArgs>) {
        this.httpHeaders = Output.all(values.asList())
    }

    /**
     * @param values Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("ttkurbkccousqibw")
    public suspend fun httpHeaders(values: List<Output<ContainerAppProbeHttpHeadersArgs>>) {
        this.httpHeaders = Output.all(values)
    }

    /**
     * @param value Path to access on the HTTP server.
     */
    @JvmName("yiwuwtcuxajemvyn")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     */
    @JvmName("qshalvutagcysnje")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     */
    @JvmName("nmenbqqpepstcnol")
    public suspend fun scheme(`value`: Output<Either<String, Scheme>>) {
        this.scheme = value
    }

    /**
     * @param value Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
     */
    @JvmName("vkyedvugmrtnlvsk")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("gdwyjeeqwshvrcij")
    public suspend fun httpHeaders(`value`: List<ContainerAppProbeHttpHeadersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("yttguqmyemytpvnv")
    public suspend fun httpHeaders(argument: List<suspend ContainerAppProbeHttpHeadersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerAppProbeHttpHeadersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("nrjujrwevsrgrwlp")
    public suspend fun httpHeaders(vararg argument: suspend ContainerAppProbeHttpHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerAppProbeHttpHeadersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("pbrifmyodvclngbd")
    public suspend fun httpHeaders(argument: suspend ContainerAppProbeHttpHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerAppProbeHttpHeadersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param values Custom headers to set in the request. HTTP allows repeated headers.
     */
    @JvmName("otjwvsvtqgarijyy")
    public suspend fun httpHeaders(vararg values: ContainerAppProbeHttpHeadersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param value Path to access on the HTTP server.
     */
    @JvmName("aswlrhajkybvgpmh")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     */
    @JvmName("myxxsqocyukkvvwg")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     */
    @JvmName("xjmvxojduwecqepw")
    public suspend fun scheme(`value`: Either<String, Scheme>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     */
    @JvmName("jmuaecxofwymslwv")
    public fun scheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Scheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     */
    @JvmName("teeftfatfqtorsjv")
    public fun scheme(`value`: Scheme) {
        val toBeMapped = Either.ofRight<String, Scheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): ContainerAppProbeHttpGetArgs = ContainerAppProbeHttpGetArgs(
        host = host,
        httpHeaders = httpHeaders,
        path = path,
        port = port ?: throw PulumiNullFieldException("port"),
        scheme = scheme,
    )
}
