@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprSubscriptionRouteRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dapr Pubsub Event Subscription Route Rule is used to specify the condition for sending a message to a specific path.
 * @property match The optional CEL expression used to match the event. If the match is not specified, then the route is considered the default. The rules are tested in the order specified, so they should be define from most-to-least specific. The default route should appear last in the list.
 * @property path The path for events that match this rule
 */
public data class DaprSubscriptionRouteRuleArgs(
    public val match: Output<String>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprSubscriptionRouteRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DaprSubscriptionRouteRuleArgs =
        com.pulumi.azurenative.app.inputs.DaprSubscriptionRouteRuleArgs.builder()
            .match(match?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprSubscriptionRouteRuleArgs].
 */
@PulumiTagMarker
public class DaprSubscriptionRouteRuleArgsBuilder internal constructor() {
    private var match: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The optional CEL expression used to match the event. If the match is not specified, then the route is considered the default. The rules are tested in the order specified, so they should be define from most-to-least specific. The default route should appear last in the list.
     */
    @JvmName("kbuiqdopfvfonvfo")
    public suspend fun match(`value`: Output<String>) {
        this.match = value
    }

    /**
     * @param value The path for events that match this rule
     */
    @JvmName("phiqdfentajrvcmd")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The optional CEL expression used to match the event. If the match is not specified, then the route is considered the default. The rules are tested in the order specified, so they should be define from most-to-least specific. The default route should appear last in the list.
     */
    @JvmName("xtdrhnleuccsgamx")
    public suspend fun match(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param value The path for events that match this rule
     */
    @JvmName("lbwnjpemutduchdq")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): DaprSubscriptionRouteRuleArgs = DaprSubscriptionRouteRuleArgs(
        match = match,
        path = path,
    )
}
