@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.EnvironmentVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model representing an environment variable.
 * @property name Environment variable name.
 * @property value Environment variable value.
 */
public data class EnvironmentVariableArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.EnvironmentVariableArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.EnvironmentVariableArgs =
        com.pulumi.azurenative.app.inputs.EnvironmentVariableArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVariableArgs].
 */
@PulumiTagMarker
public class EnvironmentVariableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Environment variable name.
     */
    @JvmName("wqufypkfvmrrphpt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Environment variable value.
     */
    @JvmName("ykdrjqefkxdqisyv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Environment variable name.
     */
    @JvmName("ofaduxcssrydnyyf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Environment variable value.
     */
    @JvmName("jmotkvfylaorljmx")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentVariableArgs = EnvironmentVariableArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
