@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetContainerAppsAuthConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authConfigName Name of the Container App AuthConfig.
 * @property containerAppName Name of the Container App.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetContainerAppsAuthConfigPlainArgs(
    public val authConfigName: String,
    public val containerAppName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetContainerAppsAuthConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetContainerAppsAuthConfigPlainArgs =
        com.pulumi.azurenative.app.inputs.GetContainerAppsAuthConfigPlainArgs.builder()
            .authConfigName(authConfigName.let({ args0 -> args0 }))
            .containerAppName(containerAppName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerAppsAuthConfigPlainArgs].
 */
@PulumiTagMarker
public class GetContainerAppsAuthConfigPlainArgsBuilder internal constructor() {
    private var authConfigName: String? = null

    private var containerAppName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Container App AuthConfig.
     */
    @JvmName("qyiiytlguhhptinr")
    public suspend fun authConfigName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authConfigName = mapped
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("mpvdsmdmlhblkqnq")
    public suspend fun containerAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerAppName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iogeyxrtoanmkngk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContainerAppsAuthConfigPlainArgs = GetContainerAppsAuthConfigPlainArgs(
        authConfigName = authConfigName ?: throw PulumiNullFieldException("authConfigName"),
        containerAppName = containerAppName ?: throw PulumiNullFieldException("containerAppName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
