@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetDaprComponentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property componentName Name of the Dapr Component.
 * @property environmentName Name of the Managed Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDaprComponentPlainArgs(
    public val componentName: String,
    public val environmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetDaprComponentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetDaprComponentPlainArgs =
        com.pulumi.azurenative.app.inputs.GetDaprComponentPlainArgs.builder()
            .componentName(componentName.let({ args0 -> args0 }))
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDaprComponentPlainArgs].
 */
@PulumiTagMarker
public class GetDaprComponentPlainArgsBuilder internal constructor() {
    private var componentName: String? = null

    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("mpiigvsgrqlwvtgp")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.componentName = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("eowtixaketnsfplf")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mrsalqlxjgywrojm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDaprComponentPlainArgs = GetDaprComponentPlainArgs(
        componentName = componentName ?: throw PulumiNullFieldException("componentName"),
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
