@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobName Job Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetJobPlainArgs(
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetJobPlainArgs =
        com.pulumi.azurenative.app.inputs.GetJobPlainArgs.builder()
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobPlainArgs].
 */
@PulumiTagMarker
public class GetJobPlainArgsBuilder internal constructor() {
    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Job Name
     */
    @JvmName("wapudnxoadtinrfr")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xobayhbibvwlrmdl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobPlainArgs = GetJobPlainArgs(
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
