@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GitHubArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the GitHub provider.
 * @property enabled <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the GitHub provider.
 */
public data class GitHubArgs(
    public val enabled: Output<Boolean>? = null,
    public val login: Output<LoginScopesArgs>? = null,
    public val registration: Output<ClientRegistrationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GitHubArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GitHubArgs =
        com.pulumi.azurenative.app.inputs.GitHubArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GitHubArgs].
 */
@PulumiTagMarker
public class GitHubArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var login: Output<LoginScopesArgs>? = null

    private var registration: Output<ClientRegistrationArgs>? = null

    /**
     * @param value <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("lfhrftsyjtsuogks")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("jfxgdxpjdmdkbtaq")
    public suspend fun login(`value`: Output<LoginScopesArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the app registration for the GitHub provider.
     */
    @JvmName("axqcskyiddbwgusp")
    public suspend fun registration(`value`: Output<ClientRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("iijsemhqlxefiwek")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("lxbhfqqlwrcydkiy")
    public suspend fun login(`value`: LoginScopesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow.
     */
    @JvmName("olqqftxjkrxdmnao")
    public suspend fun login(argument: suspend LoginScopesArgsBuilder.() -> Unit) {
        val toBeMapped = LoginScopesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the app registration for the GitHub provider.
     */
    @JvmName("apsnteatnewrjqxy")
    public suspend fun registration(`value`: ClientRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the app registration for the GitHub provider.
     */
    @JvmName("idgnhjjnoreurwcr")
    public suspend fun registration(argument: suspend ClientRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = ClientRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    internal fun build(): GitHubArgs = GitHubArgs(
        enabled = enabled,
        login = login,
        registration = registration,
    )
}
