@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.HttpConnectionPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines parameters for http connection pooling
 * @property http1MaxPendingRequests Maximum number of pending http1 requests allowed
 * @property http2MaxRequests Maximum number of http2 requests allowed
 */
public data class HttpConnectionPoolArgs(
    public val http1MaxPendingRequests: Output<Int>? = null,
    public val http2MaxRequests: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.HttpConnectionPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.HttpConnectionPoolArgs =
        com.pulumi.azurenative.app.inputs.HttpConnectionPoolArgs.builder()
            .http1MaxPendingRequests(http1MaxPendingRequests?.applyValue({ args0 -> args0 }))
            .http2MaxRequests(http2MaxRequests?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpConnectionPoolArgs].
 */
@PulumiTagMarker
public class HttpConnectionPoolArgsBuilder internal constructor() {
    private var http1MaxPendingRequests: Output<Int>? = null

    private var http2MaxRequests: Output<Int>? = null

    /**
     * @param value Maximum number of pending http1 requests allowed
     */
    @JvmName("vgrsybtashjqxqfj")
    public suspend fun http1MaxPendingRequests(`value`: Output<Int>) {
        this.http1MaxPendingRequests = value
    }

    /**
     * @param value Maximum number of http2 requests allowed
     */
    @JvmName("djlgchxppdgcoufy")
    public suspend fun http2MaxRequests(`value`: Output<Int>) {
        this.http2MaxRequests = value
    }

    /**
     * @param value Maximum number of pending http1 requests allowed
     */
    @JvmName("yblveiavybvbppae")
    public suspend fun http1MaxPendingRequests(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http1MaxPendingRequests = mapped
    }

    /**
     * @param value Maximum number of http2 requests allowed
     */
    @JvmName("yygttmlqrdxyhcug")
    public suspend fun http2MaxRequests(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2MaxRequests = mapped
    }

    internal fun build(): HttpConnectionPoolArgs = HttpConnectionPoolArgs(
        http1MaxPendingRequests = http1MaxPendingRequests,
        http2MaxRequests = http2MaxRequests,
    )
}
