@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.InitContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App init container definition
 * @property args Container start command arguments.
 * @property command Container start command.
 * @property env Container environment variables.
 * @property image Container image tag.
 * @property name Custom container name.
 * @property resources Container resource requirements.
 * @property volumeMounts Container volume mounts.
 */
public data class InitContainerArgs(
    public val args: Output<List<String>>? = null,
    public val command: Output<List<String>>? = null,
    public val env: Output<List<EnvironmentVarArgs>>? = null,
    public val image: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resources: Output<ContainerResourcesArgs>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.InitContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.InitContainerArgs =
        com.pulumi.azurenative.app.inputs.InitContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .env(env?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .image(image?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InitContainerArgs].
 */
@PulumiTagMarker
public class InitContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var command: Output<List<String>>? = null

    private var env: Output<List<EnvironmentVarArgs>>? = null

    private var image: Output<String>? = null

    private var name: Output<String>? = null

    private var resources: Output<ContainerResourcesArgs>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value Container start command arguments.
     */
    @JvmName("ryihdpdfwhnhilww")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("bcqjqjjjjhyfypro")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("gbxgtpdhmxjsirju")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Container start command.
     */
    @JvmName("doimkhxwvkactflh")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("ehnkklotpfsmafvq")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values Container start command.
     */
    @JvmName("wifncpjrgvkgsrxi")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("txmxtjjcnixxamaw")
    public suspend fun env(`value`: Output<List<EnvironmentVarArgs>>) {
        this.env = value
    }

    @JvmName("twuehbtdocrtjhgv")
    public suspend fun env(vararg values: Output<EnvironmentVarArgs>) {
        this.env = Output.all(values.asList())
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("eovmyixylulesefq")
    public suspend fun env(values: List<Output<EnvironmentVarArgs>>) {
        this.env = Output.all(values)
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("ejrgvcnsvysnwwbm")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("vtdpnsxmnmstntcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("sidgjxnxodvwdwrg")
    public suspend fun resources(`value`: Output<ContainerResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Container volume mounts.
     */
    @JvmName("ysjgtbmjiijqyova")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("xdnwaayqybsefhhq")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values Container volume mounts.
     */
    @JvmName("ensoaymwaecextpt")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value Container start command arguments.
     */
    @JvmName("xkymjcuxruinqdpx")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("mllikqktydchdxtx")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Container start command.
     */
    @JvmName("fmmvhrwaoxkgmkao")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values Container start command.
     */
    @JvmName("rtxwbanhukrevotv")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("hamxixqglovcvyys")
    public suspend fun env(`value`: List<EnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("asoueepfjsoyrect")
    public suspend fun env(argument: List<suspend EnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("ekaegubglrqovutc")
    public suspend fun env(vararg argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("sqobaqtkdjxdoqsx")
    public suspend fun env(argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVarArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("ejeocpbfebvrdksy")
    public suspend fun env(vararg values: EnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("lhibydbppafaixvr")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("xallhrhigeqkojtu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("ygtjesfjwlaegfvw")
    public suspend fun resources(`value`: ContainerResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Container resource requirements.
     */
    @JvmName("ufoulcuwegnquigy")
    public suspend fun resources(argument: suspend ContainerResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value Container volume mounts.
     */
    @JvmName("fqayvatlqdqcxflp")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("lslohvurtqjsqxnm")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("ysyckhvhuqqgvuvc")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("gwrjhqogggquivng")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values Container volume mounts.
     */
    @JvmName("cloyvsdpnbxrcqxv")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): InitContainerArgs = InitContainerArgs(
        args = args,
        command = command,
        env = env,
        image = image,
        name = name,
        resources = resources,
        volumeMounts = volumeMounts,
    )
}
