@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JavaComponentServiceBindArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration to bind a Java Component to another Java Component
 * @property name Name of the service bind
 * @property serviceId Resource id of the target service
 */
public data class JavaComponentServiceBindArgs(
    public val name: Output<String>? = null,
    public val serviceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JavaComponentServiceBindArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JavaComponentServiceBindArgs =
        com.pulumi.azurenative.app.inputs.JavaComponentServiceBindArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceId(serviceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JavaComponentServiceBindArgs].
 */
@PulumiTagMarker
public class JavaComponentServiceBindArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var serviceId: Output<String>? = null

    /**
     * @param value Name of the service bind
     */
    @JvmName("sgbvarcjhtpealin")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource id of the target service
     */
    @JvmName("gqgrxwlkpgfvmuuo")
    public suspend fun serviceId(`value`: Output<String>) {
        this.serviceId = value
    }

    /**
     * @param value Name of the service bind
     */
    @JvmName("krgmekyfofculakb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource id of the target service
     */
    @JvmName("iutsfjpwovnsjjjp")
    public suspend fun serviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceId = mapped
    }

    internal fun build(): JavaComponentServiceBindArgs = JavaComponentServiceBindArgs(
        name = name,
        serviceId = serviceId,
    )
}
