@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.SecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Secret definition.
 * @property identity Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
 * @property keyVaultUrl Azure Key Vault URL pointing to the secret referenced by the container app.
 * @property name Secret Name.
 * @property value Secret Value.
 */
public data class SecretArgs(
    public val identity: Output<String>? = null,
    public val keyVaultUrl: Output<String>? = null,
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.SecretArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.SecretArgs =
        com.pulumi.azurenative.app.inputs.SecretArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0 }))
            .keyVaultUrl(keyVaultUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var keyVaultUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
     */
    @JvmName("wshtecuxupmhkaqj")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value Azure Key Vault URL pointing to the secret referenced by the container app.
     */
    @JvmName("gwbqyoxtgogbsdst")
    public suspend fun keyVaultUrl(`value`: Output<String>) {
        this.keyVaultUrl = value
    }

    /**
     * @param value Secret Name.
     */
    @JvmName("pqstvlywqdleyndv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Secret Value.
     */
    @JvmName("ptsoyrklrrqsardf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
     */
    @JvmName("xionecdvpmxeeymg")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Azure Key Vault URL pointing to the secret referenced by the container app.
     */
    @JvmName("wucctmbvvxuusuwd")
    public suspend fun keyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUrl = mapped
    }

    /**
     * @param value Secret Name.
     */
    @JvmName("tooqmfiaywrmsoxl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Secret Value.
     */
    @JvmName("juwthvmhoydculoc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        identity = identity,
        keyVaultUrl = keyVaultUrl,
        name = name,
        `value` = `value`,
    )
}
