@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the Allowed Audiences validation flow.
 * @property allowedAudiences The configuration settings of the allowed list of audiences from which to validate the JWT token.
 */
public data class AllowedAudiencesValidationResponse(
    public val allowedAudiences: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AllowedAudiencesValidationResponse): AllowedAudiencesValidationResponse = AllowedAudiencesValidationResponse(
            allowedAudiences = javaType.allowedAudiences().map({ args0 -> args0 }),
        )
    }
}
