@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the Azure Active Directory allowed principals.
 * @property groups The list of the allowed groups.
 * @property identities The list of the allowed identities.
 */
public data class AllowedPrincipalsResponse(
    public val groups: List<String>? = null,
    public val identities: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AllowedPrincipalsResponse): AllowedPrincipalsResponse = AllowedPrincipalsResponse(
            groups = javaType.groups().map({ args0 -> args0 }),
            identities = javaType.identities().map({ args0 -> args0 }),
        )
    }
}
