@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
 * @property enabled <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
 * @property runtimeVersion The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
 */
public data class AuthPlatformResponse(
    public val enabled: Boolean? = null,
    public val runtimeVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AuthPlatformResponse): AuthPlatformResponse = AuthPlatformResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
