@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure File Properties.
 * @property accessMode Access mode for storage
 * @property accountKey Storage account key for azure file.
 * @property accountName Storage account name for azure file.
 * @property shareName Azure file share name.
 */
public data class AzureFilePropertiesResponse(
    public val accessMode: String? = null,
    public val accountKey: String? = null,
    public val accountName: String? = null,
    public val shareName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AzureFilePropertiesResponse): AzureFilePropertiesResponse = AzureFilePropertiesResponse(
            accessMode = javaType.accessMode().map({ args0 -> args0 }).orElse(null),
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            shareName = javaType.shareName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
