@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the registration for the Azure Static Web Apps provider
 * @property clientId The Client ID of the app used for login.
 */
public data class AzureStaticWebAppsRegistrationResponse(
    public val clientId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AzureStaticWebAppsRegistrationResponse): AzureStaticWebAppsRegistrationResponse = AzureStaticWebAppsRegistrationResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
