@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Certificate resource specific properties
 * @property expirationDate Certificate expiration date.
 * @property issueDate Certificate issue Date.
 * @property issuer Certificate issuer.
 * @property provisioningState Provisioning state of the certificate.
 * @property publicKeyHash Public key hash.
 * @property subjectAlternativeNames Subject alternative names the certificate applies to.
 * @property subjectName Subject name of the certificate.
 * @property thumbprint Certificate thumbprint.
 * @property valid Is the certificate valid?.
 */
public data class CertificateResponseProperties(
    public val expirationDate: String,
    public val issueDate: String,
    public val issuer: String,
    public val provisioningState: String,
    public val publicKeyHash: String,
    public val subjectAlternativeNames: List<String>,
    public val subjectName: String,
    public val thumbprint: String,
    public val valid: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CertificateResponseProperties): CertificateResponseProperties = CertificateResponseProperties(
            expirationDate = javaType.expirationDate(),
            issueDate = javaType.issueDate(),
            issuer = javaType.issuer(),
            provisioningState = javaType.provisioningState(),
            publicKeyHash = javaType.publicKeyHash(),
            subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 -> args0 }),
            subjectName = javaType.subjectName(),
            thumbprint = javaType.thumbprint(),
            valid = javaType.valid(),
        )
    }
}
