@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the app registration for providers that have client ids and client secrets
 * @property clientId The Client ID of the app used for login.
 * @property clientSecretSettingName The app setting name that contains the client secret.
 */
public data class ClientRegistrationResponse(
    public val clientId: String? = null,
    public val clientSecretSettingName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ClientRegistrationResponse): ClientRegistrationResponse = ClientRegistrationResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecretSettingName = javaType.clientSecretSettingName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
