@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container registry that the final image will be uploaded to.
 * @property image Full name that the final image should be uploaded as, including both image name and tag.
 * @property server Login server of the container registry that the final image should be uploaded to. Builder resource needs to have this container registry defined along with an identity to use to access it.
 */
public data class ContainerRegistryWithCustomImageResponse(
    public val image: String? = null,
    public val server: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ContainerRegistryWithCustomImageResponse): ContainerRegistryWithCustomImageResponse = ContainerRegistryWithCustomImageResponse(
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
        )
    }
}
