@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the session cookie's expiration.
 * @property convention The convention used when determining the session cookie's expiration.
 * @property timeToExpiration The time after the request is made when the session cookie should expire.
 */
public data class CookieExpirationResponse(
    public val convention: String? = null,
    public val timeToExpiration: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CookieExpirationResponse): CookieExpirationResponse = CookieExpirationResponse(
            convention = javaType.convention().map({ args0 -> args0 }).orElse(null),
            timeToExpiration = javaType.timeToExpiration().map({ args0 -> args0 }).orElse(null),
        )
    }
}
