@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom Domain of a Container App
 * @property bindingType Custom Domain binding type.
 * @property certificateId Resource Id of the Certificate to be bound to this hostname.
 * @property name Hostname.
 */
public data class CustomDomainResponse(
    public val bindingType: String? = null,
    public val certificateId: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CustomDomainResponse): CustomDomainResponse = CustomDomainResponse(
            bindingType = javaType.bindingType().map({ args0 -> args0 }).orElse(null),
            certificateId = javaType.certificateId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
