@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Detailed errors.
 * @property code Standardized string to programmatically identify the error.
 * @property message Detailed error description and debugging information.
 * @property target Detailed error description and debugging information.
 */
public data class CustomHostnameAnalysisResultResponseDetails(
    public val code: String,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CustomHostnameAnalysisResultResponseDetails): CustomHostnameAnalysisResultResponseDetails = CustomHostnameAnalysisResultResponseDetails(
            code = javaType.code(),
            message = javaType.message(),
            target = javaType.target(),
        )
    }
}
