@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Dapr Component Resiliency Policy HTTP Retry Backoff Configuration.
 * @property initialDelayInMilliseconds The optional initial delay in milliseconds before an operation is retried
 * @property maxIntervalInMilliseconds The optional maximum time interval in milliseconds between retry attempts
 */
public data class DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationResponse(
    public val initialDelayInMilliseconds: Int? = null,
    public val maxIntervalInMilliseconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationResponse): DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationResponse =
            DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationResponse(
                initialDelayInMilliseconds = javaType.initialDelayInMilliseconds().map({ args0 ->
                    args0
                }).orElse(null),
                maxIntervalInMilliseconds = javaType.maxIntervalInMilliseconds().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
