@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration to setup App Resiliency
 * @property circuitBreakerPolicy Policy that defines circuit breaker conditions
 * @property httpConnectionPool Defines parameters for http connection pooling
 * @property httpRetryPolicy Policy that defines http request retry conditions
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tcpConnectionPool Defines parameters for tcp connection pooling
 * @property tcpRetryPolicy Policy that defines tcp request retry conditions
 * @property timeoutPolicy Policy to set request timeouts
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAppResiliencyResult(
    public val circuitBreakerPolicy: CircuitBreakerPolicyResponse? = null,
    public val httpConnectionPool: HttpConnectionPoolResponse? = null,
    public val httpRetryPolicy: HttpRetryPolicyResponse? = null,
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val tcpConnectionPool: TcpConnectionPoolResponse? = null,
    public val tcpRetryPolicy: TcpRetryPolicyResponse? = null,
    public val timeoutPolicy: TimeoutPolicyResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetAppResiliencyResult): GetAppResiliencyResult = GetAppResiliencyResult(
            circuitBreakerPolicy = javaType.circuitBreakerPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.CircuitBreakerPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpConnectionPool = javaType.httpConnectionPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.HttpConnectionPoolResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpRetryPolicy = javaType.httpRetryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.HttpRetryPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tcpConnectionPool = javaType.tcpConnectionPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TcpConnectionPoolResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tcpRetryPolicy = javaType.tcpRetryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TcpRetryPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeoutPolicy = javaType.timeoutPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TimeoutPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
