@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An environment for Kubernetes cluster specialized for web workloads by Azure App Service
 * @property customDomainConfiguration Custom domain configuration for the environment
 * @property daprAIConnectionString Application Insights connection string used by Dapr to export Service to Service communication telemetry
 * @property defaultDomain Default Domain Name for the cluster
 * @property deploymentErrors Any errors that occurred during deployment or deployment validation
 * @property extendedLocation The complex type of the extended location.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the Kubernetes Environment.
 * @property staticIp Static IP of the connectedEnvironment
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConnectedEnvironmentResult(
    public val customDomainConfiguration: CustomDomainConfigurationResponse? = null,
    public val daprAIConnectionString: String? = null,
    public val defaultDomain: String,
    public val deploymentErrors: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val staticIp: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetConnectedEnvironmentResult): GetConnectedEnvironmentResult = GetConnectedEnvironmentResult(
            customDomainConfiguration = javaType.customDomainConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.CustomDomainConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            daprAIConnectionString = javaType.daprAIConnectionString().map({ args0 -> args0 }).orElse(null),
            defaultDomain = javaType.defaultDomain(),
            deploymentErrors = javaType.deploymentErrors(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            staticIp = javaType.staticIp().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
