@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dapr Component.
 * @property componentType Component type
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ignoreErrors Boolean describing if the component errors are ignores
 * @property initTimeout Initialization timeout
 * @property metadata Component metadata
 * @property name The name of the resource
 * @property scopes Names of container apps that can use this Dapr component
 * @property secretStoreComponent Name of a Dapr component to retrieve component secrets from
 * @property secrets Collection of secrets used by a Dapr component
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Component version
 */
public data class GetConnectedEnvironmentsDaprComponentResult(
    public val componentType: String? = null,
    public val id: String,
    public val ignoreErrors: Boolean? = null,
    public val initTimeout: String? = null,
    public val metadata: List<DaprMetadataResponse>? = null,
    public val name: String,
    public val scopes: List<String>? = null,
    public val secretStoreComponent: String? = null,
    public val secrets: List<SecretResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetConnectedEnvironmentsDaprComponentResult): GetConnectedEnvironmentsDaprComponentResult = GetConnectedEnvironmentsDaprComponentResult(
            componentType = javaType.componentType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ignoreErrors = javaType.ignoreErrors().map({ args0 -> args0 }).orElse(null),
            initTimeout = javaType.initTimeout().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.DaprMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            secretStoreComponent = javaType.secretStoreComponent().map({ args0 -> args0 }).orElse(null),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.SecretResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
