@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Container App.
 * @property configuration Non versioned Container App configuration properties.
 * @property customDomainVerificationId Id used to verify domain name ownership
 * @property environmentId Resource ID of environment.
 * @property eventStreamEndpoint The endpoint of the eventstream of the container app.
 * @property extendedLocation The complex type of the extended location.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code.
 * @property latestReadyRevisionName Name of the latest ready revision of the Container App.
 * @property latestRevisionFqdn Fully Qualified Domain Name of the latest revision of the Container App.
 * @property latestRevisionName Name of the latest revision of the Container App.
 * @property location The geo-location where the resource lives
 * @property managedEnvironmentId Deprecated. Resource ID of the Container App's environment.
 * @property name The name of the resource
 * @property outboundIpAddresses Outbound IP Addresses for container app.
 * @property provisioningState Provisioning state of the Container App.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property template Container App versioned application definition.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workloadProfileType Workload profile type to pin for container app execution.
 */
public data class GetContainerAppResult(
    public val configuration: ConfigurationResponse? = null,
    public val customDomainVerificationId: String,
    public val environmentId: String? = null,
    public val eventStreamEndpoint: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val latestReadyRevisionName: String,
    public val latestRevisionFqdn: String,
    public val latestRevisionName: String,
    public val location: String,
    public val managedEnvironmentId: String? = null,
    public val name: String,
    public val outboundIpAddresses: List<String>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val template: TemplateResponse? = null,
    public val type: String,
    public val workloadProfileType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetContainerAppResult): GetContainerAppResult = GetContainerAppResult(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customDomainVerificationId = javaType.customDomainVerificationId(),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            eventStreamEndpoint = javaType.eventStreamEndpoint(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            latestReadyRevisionName = javaType.latestReadyRevisionName(),
            latestRevisionFqdn = javaType.latestRevisionFqdn(),
            latestRevisionName = javaType.latestRevisionName(),
            location = javaType.location(),
            managedEnvironmentId = javaType.managedEnvironmentId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            outboundIpAddresses = javaType.outboundIpAddresses().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            template = javaType.template().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TemplateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            workloadProfileType = javaType.workloadProfileType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
