@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration properties that define the mutable settings of a Container App SourceControl
 * @property azureCredentials AzureCredentials configurations.
 * @property contextPath Context path
 * @property image Image name
 * @property os Operation system
 * @property publishType Code or Image
 * @property registryInfo Registry configurations.
 * @property runtimeStack Runtime stack
 * @property runtimeVersion Runtime version
 */
public data class GithubActionConfigurationResponse(
    public val azureCredentials: AzureCredentialsResponse? = null,
    public val contextPath: String? = null,
    public val image: String? = null,
    public val os: String? = null,
    public val publishType: String? = null,
    public val registryInfo: RegistryInfoResponse? = null,
    public val runtimeStack: String? = null,
    public val runtimeVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GithubActionConfigurationResponse): GithubActionConfigurationResponse = GithubActionConfigurationResponse(
            azureCredentials = javaType.azureCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AzureCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contextPath = javaType.contextPath().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            os = javaType.os().map({ args0 -> args0 }).orElse(null),
            publishType = javaType.publishType().map({ args0 -> args0 }).orElse(null),
            registryInfo = javaType.registryInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.RegistryInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runtimeStack = javaType.runtimeStack().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
