@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.
 * @property excludedPaths The paths for which unauthenticated flow would not be redirected to the login page.
 * @property redirectToProvider The default authentication provider to use when multiple providers are configured.
 * This setting is only needed if multiple providers are configured and the unauthenticated client
 * action is set to "RedirectToLoginPage".
 * @property unauthenticatedClientAction The action to take when an unauthenticated client attempts to access the app.
 */
public data class GlobalValidationResponse(
    public val excludedPaths: List<String>? = null,
    public val redirectToProvider: String? = null,
    public val unauthenticatedClientAction: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GlobalValidationResponse): GlobalValidationResponse = GlobalValidationResponse(
            excludedPaths = javaType.excludedPaths().map({ args0 -> args0 }),
            redirectToProvider = javaType.redirectToProvider().map({ args0 -> args0 }).orElse(null),
            unauthenticatedClientAction = javaType.unauthenticatedClientAction().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
