@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the Google provider.
 * @property enabled <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the Google provider.
 * @property validation The configuration settings of the Azure Active Directory token validation flow.
 */
public data class GoogleResponse(
    public val enabled: Boolean? = null,
    public val login: LoginScopesResponse? = null,
    public val registration: ClientRegistrationResponse? = null,
    public val validation: AllowedAudiencesValidationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GoogleResponse): GoogleResponse = GoogleResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            login = javaType.login().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.LoginScopesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ClientRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            validation = javaType.validation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AllowedAudiencesValidationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
