@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Conditions required to match a header
 * @property exactMatch Exact value of the header
 * @property header Name of the header
 * @property prefixMatch Prefix value of the header
 * @property regexMatch Regex value of the header
 * @property suffixMatch Suffix value of the header
 */
public data class HeaderMatchResponse(
    public val exactMatch: String? = null,
    public val `header`: String? = null,
    public val prefixMatch: String? = null,
    public val regexMatch: String? = null,
    public val suffixMatch: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.HeaderMatchResponse): HeaderMatchResponse = HeaderMatchResponse(
            exactMatch = javaType.exactMatch().map({ args0 -> args0 }).orElse(null),
            `header` = javaType.`header`().map({ args0 -> args0 }).orElse(null),
            prefixMatch = javaType.prefixMatch().map({ args0 -> args0 }).orElse(null),
            regexMatch = javaType.regexMatch().map({ args0 -> args0 }).orElse(null),
            suffixMatch = javaType.suffixMatch().map({ args0 -> args0 }).orElse(null),
        )
    }
}
