@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
 * @property forwardProxy The configuration settings of a forward proxy used to make the requests.
 * @property requireHttps <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
 * @property routes The configuration settings of the paths HTTP requests.
 */
public data class HttpSettingsResponse(
    public val forwardProxy: ForwardProxyResponse? = null,
    public val requireHttps: Boolean? = null,
    public val routes: HttpSettingsRoutesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.HttpSettingsResponse): HttpSettingsResponse = HttpSettingsResponse(
            forwardProxy = javaType.forwardProxy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ForwardProxyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requireHttps = javaType.requireHttps().map({ args0 -> args0 }).orElse(null),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.HttpSettingsRoutesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
