@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
 * @property apple The configuration settings of the Apple provider.
 * @property azureActiveDirectory The configuration settings of the Azure Active directory provider.
 * @property azureStaticWebApps The configuration settings of the Azure Static Web Apps provider.
 * @property customOpenIdConnectProviders The map of the name of the alias of each custom Open ID Connect provider to the
 * configuration settings of the custom Open ID Connect provider.
 * @property facebook The configuration settings of the Facebook provider.
 * @property gitHub The configuration settings of the GitHub provider.
 * @property google The configuration settings of the Google provider.
 * @property twitter The configuration settings of the Twitter provider.
 */
public data class IdentityProvidersResponse(
    public val apple: AppleResponse? = null,
    public val azureActiveDirectory: AzureActiveDirectoryResponse? = null,
    public val azureStaticWebApps: AzureStaticWebAppsResponse? = null,
    public val customOpenIdConnectProviders: Map<String, CustomOpenIdConnectProviderResponse>? = null,
    public val facebook: FacebookResponse? = null,
    public val gitHub: GitHubResponse? = null,
    public val google: GoogleResponse? = null,
    public val twitter: TwitterResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.IdentityProvidersResponse): IdentityProvidersResponse = IdentityProvidersResponse(
            apple = javaType.apple().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AppleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureActiveDirectory = javaType.azureActiveDirectory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AzureActiveDirectoryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureStaticWebApps = javaType.azureStaticWebApps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AzureStaticWebAppsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customOpenIdConnectProviders = javaType.customOpenIdConnectProviders().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.CustomOpenIdConnectProviderResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            facebook = javaType.facebook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.FacebookResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gitHub = javaType.gitHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.GitHubResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            google = javaType.google().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.GoogleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            twitter = javaType.twitter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TwitterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
