@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Rule to restrict incoming IP address.
 * @property action Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
 * @property description Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
 * @property ipAddressRange CIDR notation to match incoming IP address
 * @property name Name for the IP restriction rule.
 */
public data class IpSecurityRestrictionRuleResponse(
    public val action: String,
    public val description: String? = null,
    public val ipAddressRange: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.IpSecurityRestrictionRuleResponse): IpSecurityRestrictionRuleResponse = IpSecurityRestrictionRuleResponse(
            action = javaType.action(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            ipAddressRange = javaType.ipAddressRange(),
            name = javaType.name(),
        )
    }
}
