@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration to bind a Java Component to another Java Component
 * @property name Name of the service bind
 * @property serviceId Resource id of the target service
 */
public data class JavaComponentServiceBindResponse(
    public val name: String? = null,
    public val serviceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JavaComponentServiceBindResponse): JavaComponentServiceBindResponse = JavaComponentServiceBindResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            serviceId = javaType.serviceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
