@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
 * @property cronExpression Cron formatted repeating schedule ("* * * * *") of a Cron Job.
 * @property parallelism Number of parallel replicas of a job that can run at a given time.
 * @property replicaCompletionCount Minimum number of successful replica completions before overall job completion.
 */
public data class JobConfigurationResponseScheduleTriggerConfig(
    public val cronExpression: String,
    public val parallelism: Int? = null,
    public val replicaCompletionCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobConfigurationResponseScheduleTriggerConfig): JobConfigurationResponseScheduleTriggerConfig =
            JobConfigurationResponseScheduleTriggerConfig(
                cronExpression = javaType.cronExpression(),
                parallelism = javaType.parallelism().map({ args0 -> args0 }).orElse(null),
                replicaCompletionCount = javaType.replicaCompletionCount().map({ args0 -> args0 }).orElse(null),
            )
    }
}
