@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Scaling rule.
 * @property auth Authentication secrets for the scale rule.
 * @property metadata Metadata properties to describe the scale rule.
 * @property name Scale Rule Name
 * @property type Type of the scale rule
 * eg: azure-servicebus, redis etc.
 */
public data class JobScaleRuleResponse(
    public val auth: List<ScaleRuleAuthResponse>? = null,
    public val metadata: Any? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobScaleRuleResponse): JobScaleRuleResponse = JobScaleRuleResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ScaleRuleAuthResponse.Companion.toKotlin(args0)
                })
            }),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
