@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Custom domain analysis.
 * @property aRecords A records visible for this hostname.
 * @property alternateCNameRecords Alternate CName records visible for this hostname.
 * @property alternateTxtRecords Alternate TXT records visible for this hostname.
 * @property cNameRecords CName records visible for this hostname.
 * @property conflictWithEnvironmentCustomDomain <code>true</code> if there is a conflict on the Container App's managed environment level custom domain; otherwise, <code>false</code>.
 * @property conflictingContainerAppResourceId Name of the conflicting Container App on the Managed Environment if it's within the same subscription.
 * @property customDomainVerificationFailureInfo Raw failure information if DNS verification fails.
 * @property customDomainVerificationTest DNS verification test result.
 * @property hasConflictOnManagedEnvironment <code>true</code> if there is a conflict on the Container App's managed environment; otherwise, <code>false</code>.
 * @property hostName Host name that was analyzed
 * @property isHostnameAlreadyVerified <code>true</code> if hostname is already verified; otherwise, <code>false</code>.
 * @property txtRecords TXT records visible for this hostname.
 */
public data class ListContainerAppCustomHostNameAnalysisResult(
    public val aRecords: List<String>? = null,
    public val alternateCNameRecords: List<String>? = null,
    public val alternateTxtRecords: List<String>? = null,
    public val cNameRecords: List<String>? = null,
    public val conflictWithEnvironmentCustomDomain: Boolean,
    public val conflictingContainerAppResourceId: String,
    public val customDomainVerificationFailureInfo: CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo,
    public val customDomainVerificationTest: String,
    public val hasConflictOnManagedEnvironment: Boolean,
    public val hostName: String,
    public val isHostnameAlreadyVerified: Boolean,
    public val txtRecords: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ListContainerAppCustomHostNameAnalysisResult): ListContainerAppCustomHostNameAnalysisResult = ListContainerAppCustomHostNameAnalysisResult(
            aRecords = javaType.aRecords().map({ args0 -> args0 }),
            alternateCNameRecords = javaType.alternateCNameRecords().map({ args0 -> args0 }),
            alternateTxtRecords = javaType.alternateTxtRecords().map({ args0 -> args0 }),
            cNameRecords = javaType.cNameRecords().map({ args0 -> args0 }),
            conflictWithEnvironmentCustomDomain = javaType.conflictWithEnvironmentCustomDomain(),
            conflictingContainerAppResourceId = javaType.conflictingContainerAppResourceId(),
            customDomainVerificationFailureInfo = javaType.customDomainVerificationFailureInfo().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo.Companion.toKotlin(args0)
            }),
            customDomainVerificationTest = javaType.customDomainVerificationTest(),
            hasConflictOnManagedEnvironment = javaType.hasConflictOnManagedEnvironment(),
            hostName = javaType.hostName(),
            isHostnameAlreadyVerified = javaType.isHostnameAlreadyVerified(),
            txtRecords = javaType.txtRecords().map({ args0 -> args0 }),
        )
    }
}
