@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The routes that specify the endpoints used for login and logout requests.
 * @property logoutEndpoint The endpoint at which a logout request should be made.
 */
public data class LoginRoutesResponse(
    public val logoutEndpoint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.LoginRoutesResponse): LoginRoutesResponse = LoginRoutesResponse(
            logoutEndpoint = javaType.logoutEndpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
