@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the login flow of the custom Open ID Connect provider.
 * @property nameClaimType The name of the claim that contains the users name.
 * @property scopes A list of the scopes that should be requested while authenticating.
 */
public data class OpenIdConnectLoginResponse(
    public val nameClaimType: String? = null,
    public val scopes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.OpenIdConnectLoginResponse): OpenIdConnectLoginResponse = OpenIdConnectLoginResponse(
            nameClaimType = javaType.nameClaimType().map({ args0 -> args0 }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }),
        )
    }
}
