@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model representing a pre-build step.
 * @property description Description of the pre-build step.
 * @property httpGet Http get request to send before the build.
 * @property scripts List of custom commands to run.
 */
public data class PreBuildStepResponse(
    public val description: String? = null,
    public val httpGet: HttpGetResponse? = null,
    public val scripts: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.PreBuildStepResponse): PreBuildStepResponse = PreBuildStepResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            httpGet = javaType.httpGet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.HttpGetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scripts = javaType.scripts().map({ args0 -> args0 }),
        )
    }
}
