@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container App container Azure Queue based scaling rule.
 * @property auth Authentication secrets for the queue scale rule.
 * @property queueLength Queue length.
 * @property queueName Queue name.
 */
public data class QueueScaleRuleResponse(
    public val auth: List<ScaleRuleAuthResponse>? = null,
    public val queueLength: Int? = null,
    public val queueName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.QueueScaleRuleResponse): QueueScaleRuleResponse = QueueScaleRuleResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ScaleRuleAuthResponse.Companion.toKotlin(args0)
                })
            }),
            queueLength = javaType.queueLength().map({ args0 -> args0 }).orElse(null),
            queueName = javaType.queueName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
