@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App Private Registry
 * @property identity A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
 * @property passwordSecretRef The name of the Secret that contains the registry login password
 * @property server Container Registry Server
 * @property username Container Registry Username
 */
public data class RegistryCredentialsResponse(
    public val identity: String? = null,
    public val passwordSecretRef: String? = null,
    public val server: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.RegistryCredentialsResponse): RegistryCredentialsResponse = RegistryCredentialsResponse(
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            passwordSecretRef = javaType.passwordSecretRef().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
