@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App registry information.
 * @property registryUrl registry server Url.
 * @property registryUserName registry username.
 */
public data class RegistryInfoResponse(
    public val registryUrl: String? = null,
    public val registryUserName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.RegistryInfoResponse): RegistryInfoResponse = RegistryInfoResponse(
            registryUrl = javaType.registryUrl().map({ args0 -> args0 }).orElse(null),
            registryUserName = javaType.registryUserName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
