@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Defines parameters for tcp connection pooling
 * @property maxConnections Maximum number of tcp connections allowed
 */
public data class TcpConnectionPoolResponse(
    public val maxConnections: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.TcpConnectionPoolResponse): TcpConnectionPoolResponse = TcpConnectionPoolResponse(
            maxConnections = javaType.maxConnections().map({ args0 -> args0 }).orElse(null),
        )
    }
}
