@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Container App container Tcp scaling rule.
 * @property auth Authentication secrets for the tcp scale rule.
 * @property metadata Metadata properties to describe tcp scale rule.
 */
public data class TcpScaleRuleResponse(
    public val auth: List<ScaleRuleAuthResponse>? = null,
    public val metadata: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.TcpScaleRuleResponse): TcpScaleRuleResponse = TcpScaleRuleResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ScaleRuleAuthResponse.Companion.toKotlin(args0)
                })
            }),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
